package gov.va.med.mhv.sm.admin.dto;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class ActivityDTO implements Serializable {

	private static final long serialVersionUID = 7379153360178686747L;

	private static final String SUCCESSFUL = "Successful";
	private static final String UNSUCCESSFUL = "Unsuccessful";

	private Long activityId;
	private Long userProfileId;
	private Long patientId;
	private String action;
	private Boolean status;
	private String performerType;
	private String activityType;
	private String detailValue;
	private Date completionTime;
	private UserProfileDTO userProfileDTO;

	public Long getActivityId() {
		return activityId;
	}

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public Boolean getStatus() {
		return status;
	}

	public void setStatus(Boolean status) {
		this.status = status;
	}

	public String getPerformerType() {
		return performerType;
	}

	public void setPerformerType(String performerType) {
		this.performerType = performerType;
	}

	public String getActivityType() {
		return activityType;
	}

	public void setActivityType(String activityType) {
		this.activityType = activityType;
	}

	public String getDetailValue() {
		if(detailValue != null && detailValue.trim().length()>0) {
			return detailValue;
		}
		return "None";
	}

	public void setDetailValue(String detailValue) {
		this.detailValue = detailValue;
	}

	public Date getCompletionTime() {
		return completionTime;
	}

	public void setCompletionTime(Date completionTime) {
		this.completionTime = completionTime;
	}

	public UserProfileDTO getUserProfileDTO() {
		return userProfileDTO;
	}

	public void setUserProfileDTO(UserProfileDTO userProfileDTO) {
		this.userProfileDTO = userProfileDTO;
	}

	@JsonIgnore
	public String getDisplayCompletionDate() {
		String completedDate="";

		DateFormat dtfmt = new SimpleDateFormat( "M/d/yyyy hh:mm:ss a z");
		dtfmt.setTimeZone(TimeZone.getTimeZone("America/New_York"));
		completedDate=dtfmt.format(getCompletionTime());

		return	(getCompletionTime() != null) ? completedDate: null;
	}

	@JsonIgnore
	public String getDisplayStatus() {
		if (getStatus() != null) {
			return (getStatus()) ? SUCCESSFUL : UNSUCCESSFUL;
		}
		return null;
	}

}